<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name     = strip_tags(trim($_POST["name"]));
    $email    = filter_var(trim($_POST["email"]), FILTER_SANITIZE_EMAIL);
    $industry = strip_tags(trim($_POST["industry"]));
    $phone    = strip_tags(trim($_POST["phone"]));
    $message  = trim($_POST["message"]);

    if (empty($name) || !filter_var($email, FILTER_VALIDATE_EMAIL) || empty($message)) {
        echo "Please fill out all required fields and provide a valid email.";
        exit;
    }

    $to = "bibinokt@gmail.com"; // Replace with your real email
    $subject = "New Contact Request from $name";
    $email_content = "Name: $name\n";
    $email_content .= "Email: $email\n";
    $email_content .= "Industry: $industry\n";
    $email_content .= "Phone: $phone\n";
    $email_content .= "Message:\n$message\n";

    $headers = "From: $name <$email>";

    if (mail($to, $subject, $email_content, $headers)) {
        echo "Thank you! Your message has been sent.";
    } else {
        echo "Oops! Something went wrong. Please try again later.";
    }
} else {
    echo "Invalid request.";
}
